# coding:utf-8
import arcpy
import sys
import traceback

# 消息写出
def outputMsg(msg):
    arcpy.AddMessage(msg)


try:
    database = sys.argv[1]  # 数据库路径
    checkLayerName = sys.argv[2]  # 检查图层名称
    checkLayerWhere = sys.argv[3]  # 相关图层筛选条件
    relatedLayerName = sys.argv[4]  # 相关图层名称
    relatedLayerWhere = sys.argv[5]  # 相关图层筛选条件
    spatialRelation = sys.argv[6]  # 空间关系
    lineNodeType = sys.argv[7]  # 点对应线的节点类型
    pointLineCorrespondenceType = sys.argv[8]  # 点和节点的对应关系
    checkBuffer = sys.argv[9]  # 检查缓冲值
    filterObjects = sys.argv[10]  # 多个过滤对象(包含图层名称和筛选条件)需解析
    # filterLayerName = sys.argv[10]  # 过滤图层名称
    # filterLayerWhere = sys.argv[11]  # 过滤图层筛选条件
    filterBuffer = sys.argv[11]  # 过滤缓冲值
    maxAllowResultNum = sys.argv[12]  # 消息输出最大数量

    # database = arcpy.GetParameter(0)  # 数据库路径
    # checkLayerName = arcpy.GetParameter(1)  # 检查图层名称
    # checkLayerWhere = arcpy.GetParameter(2)  # 相关图层筛选条件
    # relatedLayerName = arcpy.GetParameter(3)  # 相关图层名称
    # relatedLayerWhere = arcpy.GetParameter(4)  # 相关图层筛选条件
    # spatialRelation = arcpy.GetParameter(5)  # 空间关系
    # checkBuffer = arcpy.GetParameter(6)  # 检查缓冲值
    # lineNodeType = arcpy.GetParameter(7)  # 点对应线的节点类型
    # pointLineCorrespondenceType = arcpy.GetParameter(8)  # 点和节点的对应关系
    # filterLayerName = arcpy.GetParameter(9)  # 过滤图层名称
    # filterLayerWhere = arcpy.GetParameter(10)  # 过滤图层筛选条件
    # filterBuffer = arcpy.GetParameter(11)  # 过滤缓冲值

    # database = 'E:\\1、测试数据及相关资料\\2023年城市监测\\测试数据\\点线关系测试.gdb'
    # checkLayerName = 'AAAP'
    # checkLayerWhere = ''
    # relatedLayerName = 'AAAL'
    # relatedLayerWhere = ''
    # checkBuffer = 0
    # spatialRelation = '重叠'
    # lineNodeType = '全部节点'
    # pointLineCorrespondenceType = '一一对应'

    arcpy.env.workspace = database

    if checkLayerWhere == 'None':
        checkLayerWhere = ''
    else:
        checkLayerWhere = checkLayerWhere.replace("!?", " ")
    if relatedLayerWhere == 'None':
        relatedLayerWhere = ''
    else:
        relatedLayerWhere = relatedLayerWhere.replace("!?", " ")

    # 多个过滤对象
    filterObjectArr = filterObjects.split(';')
    for index in range(len(filterObjectArr)):
        filterObjectArr[index] = filterObjectArr[index].replace("!?", " ")

    # 从VS2019传过来的字符串默认是gb2312编码，需要转换比较
    spatialRelation = spatialRelation.decode('gb2312').encode('utf-8')
    lineNodeType = lineNodeType.decode('gb2312').encode('utf-8')
    pointLineCorrespondenceType = pointLineCorrespondenceType.decode('gb2312').encode('utf-8')

    # 获取检查图层和相关图层的几何类型
    checkLayerType = arcpy.Describe(checkLayerName).shapeType
    relatedLayerType = arcpy.Describe(relatedLayerName).shapeType


except Exception as e:
    outputMsg('错误意见')
    traceback.print_exc()

def CheckByCorrespondenceType(checkLayer, relatedLayer):
    resultNum = 0
    if pointLineCorrespondenceType == '一一对应':  # 选择检查图层要素中，不重叠的要素；选择相关图层要素中，不重叠的要素
        arcpy.SelectLayerByLocation_management(checkLayer, 'WITHIN_A_DISTANCE', relatedLayer, checkBuffer,
                                               'NEW_SELECTION')
        arcpy.SelectLayerByLocation_management(checkLayer, '', '', checkBuffer, 'SWITCH_SELECTION')
        if filterObjects != 'None':
            for filterObject in filterObjectArr:  # 排除过滤对象
                filterList = filterObject.split(':')
                filterLayerName = filterList[0]
                filterLayerWhere = filterList[1]
                if filterLayerWhere == 'None':
                    filterLayerWhere = ''
                if arcpy.Exists('filterLayer') == False:
                    arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                arcpy.SelectLayerByLocation_management(checkLayer, 'WITHIN_A_DISTANCE', 'filterLayer',
                                                       filterBuffer, 'REMOVE_FROM_SELECTION')
        fields = ['ObjectID']
        if checkLayerType == 'Polyline':
            fields = ['ORIG_FID', 'ObjectID']
        outputMsg('检查图层意见OID')
        with arcpy.da.SearchCursor(checkLayer, fields) as cursor:
            for row in cursor:
                resultNum += 1
                if resultNum > int(maxAllowResultNum):
                    return
                if len(fields) > 1:
                    outputMsg(str(row[0]) + ',' + str(row[1]))
                else:
                    outputMsg(row[0])
        arcpy.SelectLayerByAttribute_management(checkLayer,'NEW_SELECTION','')  # 清空检查层的选择要素

        arcpy.SelectLayerByLocation_management(relatedLayer, 'WITHIN_A_DISTANCE', checkLayer, checkBuffer,
                                               'NEW_SELECTION')
        arcpy.SelectLayerByLocation_management(relatedLayer, '', '', checkBuffer, 'SWITCH_SELECTION')
        if filterObjects != 'None':
            for filterObject in filterObjectArr:  # 排除过滤对象
                filterList = filterObject.split(':')
                filterLayerName = filterList[0]
                filterLayerWhere = filterList[1]
                if filterLayerWhere == 'None':
                    filterLayerWhere = ''
                if arcpy.Exists('filterLayer') == False:
                    arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                arcpy.SelectLayerByLocation_management(relatedLayer, 'WITHIN_A_DISTANCE', 'filterLayer',
                                                       filterBuffer, 'REMOVE_FROM_SELECTION')
        fields = ['ORIG_FID', 'ObjectID']
        if relatedLayerType == 'Point':
            fields = ['ObjectID']
        outputMsg('相关图层意见OID')
        with arcpy.da.SearchCursor(relatedLayer, fields) as cursor:
            for row in cursor:
                resultNum += 1
                if resultNum > int(maxAllowResultNum):
                    return
                if len(fields) > 1:
                    outputMsg(str(row[0]) + ',' + str(row[1]))
                else:
                    outputMsg(row[0])

    elif pointLineCorrespondenceType == '包含对应':  # 检查图层的点要素是包含相关图层的点要素，选择相关图层要素中，不重叠的要素
        arcpy.SelectLayerByLocation_management(relatedLayer, 'WITHIN_A_DISTANCE', checkLayer, checkBuffer,
                                               'NEW_SELECTION')
        arcpy.SelectLayerByLocation_management(relatedLayer, '', '', checkBuffer, 'SWITCH_SELECTION')
        if filterObjects != 'None':
            for filterObject in filterObjectArr:  # 排除过滤对象
                filterList = filterObject.split(':')
                filterLayerName = filterList[0]
                filterLayerWhere = filterList[1]
                if filterLayerWhere == 'None':
                    filterLayerWhere = ''
                if arcpy.Exists('filterLayer') == False:
                    arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                arcpy.SelectLayerByLocation_management(relatedLayer, 'WITHIN_A_DISTANCE', 'filterLayer',
                                                       filterBuffer, 'REMOVE_FROM_SELECTION')
        fields = ['ORIG_FID', 'ObjectID']
        if relatedLayerType == 'Point':
            fields = ['ObjectID']
        outputMsg('相关图层意见OID')
        with arcpy.da.SearchCursor(relatedLayer, fields) as cursor:
            for row in cursor:
                resultNum += 1
                if resultNum > int(maxAllowResultNum):
                    return
                if len(fields) > 1:
                    outputMsg(str(row[0]) + ',' + str(row[1]))
                else:
                    outputMsg(row[0])
    else:  # 被包含对应，检查图层的点要素是被相关图层的点要素包含，选择检查图层要素中，不重叠的要素
        arcpy.SelectLayerByLocation_management(checkLayer, 'WITHIN_A_DISTANCE', relatedLayer, checkBuffer,
                                               'NEW_SELECTION')
        arcpy.SelectLayerByLocation_management(checkLayer, '', '', checkBuffer, 'SWITCH_SELECTION')
        if filterObjects != 'None':
            for filterObject in filterObjectArr:  # 排除过滤对象
                filterList = filterObject.split(':')
                filterLayerName = filterList[0]
                filterLayerWhere = filterList[1]
                if filterLayerWhere == 'None':
                    filterLayerWhere = ''
                if arcpy.Exists('filterLayer') == False:
                    arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                arcpy.SelectLayerByLocation_management(checkLayer, 'WITHIN_A_DISTANCE', 'filterLayer',
                                                       filterBuffer, 'REMOVE_FROM_SELECTION')
        fields = ['ObjectID']
        if checkLayerType == 'Polyline':
            fields = ['ORIG_FID', 'ObjectID']
        outputMsg('检查图层意见OID')
        with arcpy.da.SearchCursor(checkLayer, fields) as cursor:
            for row in cursor:
                resultNum += 1
                if resultNum > int(maxAllowResultNum):
                    return
                if len(fields) > 1:
                    outputMsg(str(row[0]) + ',' + str(row[1]))
                else:
                    outputMsg(row[0])

def main():
    try:
        resultNum = 0
        if checkLayerType == 'Point' and relatedLayerType == 'Polyline':
            if spatialRelation == '重叠':
                if lineNodeType == '全部节点':  # 将线要素转为全部节点要素
                    if arcpy.Exists('relatedPointFC'):  # 防止临时数据没删掉
                        arcpy.Delete_management('relatedPointFC')
                    arcpy.FeatureVerticesToPoints_management(relatedLayerName, 'relatedPointFC', 'ALL')
                    checkLayer = arcpy.MakeFeatureLayer_management(checkLayerName, 'checkLayer', checkLayerWhere)
                    relatedLayer = arcpy.MakeFeatureLayer_management('relatedPointFC', 'relatedPointLayer', relatedLayerWhere)
                    CheckByCorrespondenceType('checkLayer', 'relatedPointLayer')
                elif lineNodeType == '端点':  # 将线要素转为内部节点要素
                    if arcpy.Exists('relatedPointFC'):  # 防止临时数据没删掉
                        arcpy.Delete_management('relatedPointFC')
                    arcpy.FeatureVerticesToPoints_management(relatedLayerName, 'relatedPointFC', 'BOTH_ENDS')
                    checkLayer = arcpy.MakeFeatureLayer_management(checkLayerName, 'checkLayer', checkLayerWhere)
                    relatedLayer = arcpy.MakeFeatureLayer_management('relatedPointFC', 'relatedPointLayer', relatedLayerWhere)
                    CheckByCorrespondenceType('checkLayer', 'relatedPointLayer')
                elif lineNodeType == '内部节点':  # 将线要素转为全部节点要素，和内部节点要素，再交集取反
                    if arcpy.Exists('relatedAllPointFC'):  # 将线要素转为全部节点要素
                        arcpy.Delete_management('relatedAllPointFC')
                    if arcpy.Exists('relatedEndPointFC'):
                        arcpy.Delete_management('relatedEndPointFC')
                    if arcpy.Exists('relatedPointFC'):
                        arcpy.Delete_management('relatedPointFC')
                    arcpy.FeatureVerticesToPoints_management(relatedLayerName, 'relatedAllPointFC', 'ALL')
                    arcpy.FeatureVerticesToPoints_management(relatedLayerName, 'relatedEndPointFC', 'BOTH_ENDS')
                    arcpy.SymDiff_analysis('relatedAllPointFC', 'relatedEndPointFC', 'relatedPointFC', "ALL")
                    checkLayer = arcpy.MakeFeatureLayer_management(checkLayerName, 'checkLayer', checkLayerWhere)
                    relatedLayer = arcpy.MakeFeatureLayer_management('relatedPointFC', 'relatedPointLayer', relatedLayerWhere)
                    CheckByCorrespondenceType('checkLayer', 'relatedPointLayer')
                    if arcpy.Exists('relatedAllPointFC'):  # 将线要素转为全部节点要素
                        arcpy.Delete_management('relatedAllPointFC')
                    if arcpy.Exists('relatedEndPointFC'):
                        arcpy.Delete_management('relatedEndPointFC')
                else:  # 重叠情况（不考虑点与线节点对应）
                    arcpy.MakeFeatureLayer_management(checkLayerName, 'checkLayer', checkLayerWhere)
                    arcpy.MakeFeatureLayer_management(relatedLayerName, 'relatedLayer', relatedLayerWhere)
                    arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'relatedLayer', checkBuffer,
                                                           'NEW_SELECTION')
                    arcpy.SelectLayerByLocation_management('checkLayer', '', '', checkBuffer, 'SWITCH_SELECTION')
                    if filterObjects != 'None':
                        for filterObject in filterObjectArr:  # 排除过滤对象
                            filterList = filterObject.split(':')
                            filterLayerName = filterList[0]
                            filterLayerWhere = filterList[1]
                            if filterLayerWhere == 'None':
                                filterLayerWhere = ''
                            if arcpy.Exists('filterLayer') == False:
                                arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                            arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                                                                   filterBuffer, 'REMOVE_FROM_SELECTION')
                    fields = ['ObjectID']
                    outputMsg('检查图层意见OID')
                    with arcpy.da.SearchCursor('checkLayer', fields) as cursor:
                        for row in cursor:
                            resultNum += 1
                            if resultNum > int(maxAllowResultNum):
                                return
                            outputMsg(row[0])
                    # arcpy.SelectLayerByAttribute_management('checkLayer', 'NEW_SELECTION', '')  # 清空检查层的选择要素
                    # arcpy.SelectLayerByLocation_management('relatedLayer', 'WITHIN_A_DISTANCE', 'checkLayer', checkBuffer,
                    #                                        'NEW_SELECTION')
                    # arcpy.SelectLayerByLocation_management('relatedLayer', '', '', checkBuffer, 'SWITCH_SELECTION')
                    # if filterObjects != 'None':
                    #     for filterObject in filterObjectArr:  # 排除过滤对象
                    #         filterList = filterObject.split(':')
                    #         filterLayerName = filterList[0]
                    #         filterLayerWhere = filterList[1]
                    #         if filterLayerWhere == 'None':
                    #             filterLayerWhere = ''
                    #         if arcpy.Exists('filterLayer') == False:
                    #             arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                    #         arcpy.SelectLayerByLocation_management('relatedLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                    #                                                filterBuffer, 'REMOVE_FROM_SELECTION')
                    # outputMsg('相关图层意见OID')
                    # with arcpy.da.SearchCursor('relatedLayer', fields) as cursor:
                    #     for row in cursor:
                    #         resultNum += 1
                    #         if resultNum > int(maxAllowResultNum):
                    #             return
                    #         outputMsg(row[0])
            else:  # 相离情况(选择检查图层要素中，重叠的要素)
                arcpy.MakeFeatureLayer_management(checkLayerName, 'checkLayer', checkLayerWhere)
                arcpy.MakeFeatureLayer_management(relatedLayerName, 'relatedLayer', relatedLayerWhere)
                arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'relatedLayer', checkBuffer,
                                                       'NEW_SELECTION')
                if filterObjects != 'None':
                    for filterObject in filterObjectArr:  # 排除过滤对象
                        filterList = filterObject.split(':')
                        filterLayerName = filterList[0]
                        filterLayerWhere = filterList[1]
                        if filterLayerWhere == 'None':
                            filterLayerWhere = ''
                        if arcpy.Exists('filterLayer') == False:
                            arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                        arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                                                               filterBuffer, 'REMOVE_FROM_SELECTION')
                fields = ['ObjectID']
                outputMsg('检查图层意见OID')
                with arcpy.da.SearchCursor('checkLayer', fields) as cursor:
                    for row in cursor:
                        resultNum += 1
                        if resultNum > int(maxAllowResultNum):
                            return
                        outputMsg(row[0])
        if checkLayerType == 'Polyline' and relatedLayerType == 'Point':
            if spatialRelation == '重叠':
                if lineNodeType == '全部节点':  # 将线要素转为全部节点要素
                    if arcpy.Exists('checkPointFC'):  # 防止临时数据没删掉
                        arcpy.Delete_management('checkPointFC')
                    arcpy.FeatureVerticesToPoints_management(checkLayerName, 'checkPointFC', 'ALL')
                    relatedLayer = arcpy.MakeFeatureLayer_management(relatedLayerName, 'relatedLayer', relatedLayerWhere)
                    checkLayer = arcpy.MakeFeatureLayer_management('checkPointFC', 'checkPointLayer', checkLayerWhere)
                    CheckByCorrespondenceType('checkPointLayer', 'relatedLayer')
                elif lineNodeType == '端点':  # 将线要素转为内部节点要素
                    if arcpy.Exists('checkPointFC'):  # 防止临时数据没删掉
                        arcpy.Delete_management('checkPointFC')
                    arcpy.FeatureVerticesToPoints_management(checkLayerName, 'checkPointFC', 'BOTH_ENDS')
                    relatedLayer = arcpy.MakeFeatureLayer_management(relatedLayerName, 'relatedLayer', relatedLayerWhere)
                    checkLayer = arcpy.MakeFeatureLayer_management('checkPointFC', 'checkPointLayer', relatedLayerWhere)
                    CheckByCorrespondenceType('checkPointLayer', 'relatedLayer')
                elif lineNodeType == '内部节点':  # 将线要素转为全部节点要素，和内部节点要素，再交集取反
                    if arcpy.Exists('checkAllPointFC'):  # 防止临时数据没删掉
                        arcpy.Delete_management('checkAllPointFC')
                    if arcpy.Exists('checkEndPointFC'):
                        arcpy.Delete_management('checkEndPointFC')
                    if arcpy.Exists('checkPointFC'):
                        arcpy.Delete_management('checkPointFC')
                    arcpy.FeatureVerticesToPoints_management(checkLayerName, 'checkAllPointFC', 'ALL')
                    arcpy.FeatureVerticesToPoints_management(checkLayerName, 'checkEndPointFC', 'BOTH_ENDS')
                    arcpy.SymDiff_analysis('checkAllPointFC', 'checkEndPointFC', 'checkPointFC', "ALL")
                    relatedLayer = arcpy.MakeFeatureLayer_management(relatedLayerName, 'relatedLayer', relatedLayerWhere)
                    checkLayer = arcpy.MakeFeatureLayer_management('checkPointFC', 'checkPointLayer', checkLayerWhere)
                    CheckByCorrespondenceType('checkPointLayer', 'relatedLayer')
                    if arcpy.Exists('checkAllPointFC'):  # 防止临时数据没删掉
                        arcpy.Delete_management('checkAllPointFC')
                    if arcpy.Exists('checkEndPointFC'):
                        arcpy.Delete_management('checkEndPointFC')
                else:  # 重叠情况（不考虑点与线节点对应）
                    arcpy.MakeFeatureLayer_management(checkLayerName, 'checkLayer', checkLayerWhere)
                    arcpy.MakeFeatureLayer_management(relatedLayerName, 'relatedLayer', relatedLayerWhere)
                    arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'relatedLayer', checkBuffer,
                                                           'NEW_SELECTION')
                    arcpy.SelectLayerByLocation_management('checkLayer', '', '', checkBuffer, 'SWITCH_SELECTION')
                    if filterObjects != 'None':
                        for filterObject in filterObjectArr:  # 排除过滤对象
                            filterList = filterObject.split(':')
                            filterLayerName = filterList[0]
                            filterLayerWhere = filterList[1]
                            if filterLayerWhere == 'None':
                                filterLayerWhere = ''
                            if arcpy.Exists('filterLayer') == False:
                                arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                            arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                                                                   filterBuffer, 'REMOVE_FROM_SELECTION')
                    fields = ['ObjectID']
                    outputMsg('检查图层意见OID')
                    with arcpy.da.SearchCursor('checkLayer', fields) as cursor:
                        for row in cursor:
                            outputMsg(row[0])
                    # arcpy.SelectLayerByAttribute_management('checkLayer', 'NEW_SELECTION', '')  # 清空检查层的选择要素
                    # arcpy.SelectLayerByLocation_management('relatedLayer', 'WITHIN_A_DISTANCE', 'checkLayer', checkBuffer,
                    #                                        'NEW_SELECTION')
                    # arcpy.SelectLayerByLocation_management('relatedLayer', '', '', checkBuffer, 'SWITCH_SELECTION')
                    # if filterObjects != 'None':
                    #     for filterObject in filterObjectArr:  # 排除过滤对象
                    #         filterList = filterObject.split(':')
                    #         filterLayerName = filterList[0]
                    #         filterLayerWhere = filterList[1]
                    #         if filterLayerWhere == 'None':
                    #             filterLayerWhere = ''
                    #         if arcpy.Exists('filterLayer') == False:
                    #             arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                    #         arcpy.SelectLayerByLocation_management('relatedLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                    #                                                filterBuffer, 'REMOVE_FROM_SELECTION')
                    # outputMsg('相关图层意见OID')
                    # with arcpy.da.SearchCursor('relatedLayer', fields) as cursor:
                    #     for row in cursor:
                    #         outputMsg(row[0])
            else:  # 相离情况(选择检查图层要素中，重叠的要素)
                arcpy.MakeFeatureLayer_management(checkLayerName, 'checkLayer', checkLayerWhere)
                arcpy.MakeFeatureLayer_management(relatedLayerName, 'relatedLayer', relatedLayerWhere)
                arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'relatedLayer', checkBuffer,
                                                       'NEW_SELECTION')
                if filterObjects != 'None':
                    for filterObject in filterObjectArr:  # 排除过滤对象
                        filterList = filterObject.split(':')
                        filterLayerName = filterList[0]
                        filterLayerWhere = filterList[1]
                        if filterLayerWhere == 'None':
                            filterLayerWhere = ''
                        if arcpy.Exists('filterLayer') == False:
                            arcpy.MakeFeatureLayer_management(filterLayerName, 'filterLayer', filterLayerWhere)
                        arcpy.SelectLayerByLocation_management('checkLayer', 'WITHIN_A_DISTANCE', 'filterLayer',
                                                               filterBuffer, 'REMOVE_FROM_SELECTION')
                fields = ['ObjectID']
                outputMsg('检查图层意见OID')
                with arcpy.da.SearchCursor('checkLayer', fields) as cursor:
                    for row in cursor:
                        outputMsg(row[0])
    except Exception as e:
        if arcpy.Exists('checkAllPointFC'):  # 防止临时数据没删掉
            arcpy.Delete_management('checkAllPointFC')
        if arcpy.Exists('checkEndPointFC'):
            arcpy.Delete_management('checkEndPointFC')
        if arcpy.Exists('relatedAllPointFC'):  # 将线要素转为全部节点要素
            arcpy.Delete_management('relatedAllPointFC')
        if arcpy.Exists('relatedEndPointFC'):
            arcpy.Delete_management('relatedEndPointFC')
        outputMsg('错误意见')
        # outputMsg(e.message)
        # msg = traceback.format_exc()
        # outputMsg(msg)
        traceback.print_exc()

if __name__ == "__main__":
    main()